import 'package:rad/rad.dart';

import 'package:photogram_admin_cp/config.dart';

import 'package:photogram_admin_cp/import/core.dart';
import 'package:photogram_admin_cp/import/data.dart';

class ApiRepository {
  static ApiRepository of(BuildContext context) => AppProvider.of(context).apiRepo;

  /*
  |--------------------------------------------------------------------------
  | api provider
  |--------------------------------------------------------------------------
  */

  final ApiProvider _apiProvider = ApiProvider(apiUrl: "${APP_SERVER_URL}api/admin/", apiVersion: APP_API_VERSION);

  ApiRepository() {
    AppLogger.info("ApiRepository: Init");
  }

  /*
  |--------------------------------------------------------------------------
  | temporary files will be sent on next request and will be removed after that
  |--------------------------------------------------------------------------
  */

  void attachFile(FileDetails fileDetails) {
    // generate random key
    var randomKey = AppUtils.random();

    while (_apiProvider.isAttachmentKeyAvailable(randomKey)) {
      randomKey = AppUtils.random();
    }

    _apiProvider.addAttachment(randomKey, fileDetails);
  }

  void clearAttachments() {
    _apiProvider.clearAttachments();
  }

  /*
  |--------------------------------------------------------------------------
  | prepared request
  |--------------------------------------------------------------------------
  */

  Future<ResponseModel> preparedRequest({
    required String requestType,
    required Map<String, dynamic> requestData,
  }) async =>
      _apiProvider.preparedRequest(
        requestType: requestType,
        requestData: requestData,
      );

  /*
  |--------------------------------------------------------------------------
  | auth session request
  |--------------------------------------------------------------------------
  */

  Future<ResponseModel> authSession() async => _apiProvider.adminAuthSession();

  /*
  |--------------------------------------------------------------------------
  | single item requests
  |--------------------------------------------------------------------------
  */

  Future<ResponseModel> userById({
    required String userId,
  }) async =>
      _apiProvider.preparedRequest(
        requestType: REQ_TYPE_ADMIN_USER_LOAD_SINGLE,
        requestData: {
          UserTable.tableName: {UserTable.id: userId},
        },
      );
}
